% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survivalAnalysis.R
\name{survivalAnalysis}
\alias{survivalAnalysis}
\title{Survival analysis based on significant IC}
\usage{
survivalAnalysis(cica, surv = NULL, time = NULL, event = NULL, fdr = 0.05)
}
\arguments{
\item{cica}{list compliant to `consICA()` result}

\item{surv}{dataframe with time and event values for each sample. Use this
parameter or `time` and `event`}

\item{time}{survival time value for each sample}

\item{event}{survival event factor for each sample (TRUE or FALSE)}

\item{fdr}{false discovery rate threshold for significant components 
involved in final model. Default value is 0.05}
}
\value{
a list with
    \item{cox.model}{an object of class `coxph` representing the fit. 
See `coxph.object` for details}
    \item{hazard.score}{hazard score for significant components (fdr < `fdr` 
    in individual cox model)}
}
\description{
Cox regression (based on R package `survival`) on the weights 
of independent components with significant contribution in individual
risk model. For more see Nazarov et al. 2019 
In addition the function plot Kaplan-Meier diagram.
}
\examples{
data("samples_data")
# Get deconvolution of X matrix
cica <-  consICA(samples_data, ncomp=10, ntry=1, show.every=0)
surv <- survivalAnalysis(cica, 
  surv = SummarizedExperiment::colData(samples_data)[,c("time", "event")]) 
}
