% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consICA.R
\name{consICA}
\alias{consICA}
\title{Calculate consensus Independent Component Analysis}
\usage{
consICA(
  X,
  ncomp = 10,
  ntry = 1,
  show.every = 1,
  filter.thr = NULL,
  ncores = 1,
  bpparam = NULL,
  reduced = FALSE,
  fun = "logcosh",
  alg.typ = "deflation",
  verbose = FALSE,
  assay_string = NULL
)
}
\arguments{
\item{X}{input data with features in rows and samples in columns. 
Could be a `SummarizedExperiment` object, matrix or `Seurat` object. 
For `SummarizedExperiment` with multiple assays or `Seurat` pass the name 
with `assay_string` parameter, otherwise the first will be taken.
See \code{\link[SummarizedExperiment]{SummarizedExperiment-class}}}

\item{ncomp}{number of components}

\item{ntry}{number of consensus runs. Default value is 1}

\item{show.every}{numeric logging period in iterations (disabled for 
`ncore`s > 1). Default value is 1}

\item{filter.thr}{Filter out genes (rows) with max value lower than this 
value from `X`}

\item{ncores}{number of cores for parallel calculation. Default 
value is 4}

\item{bpparam}{parameters from the `BiocParallel`}

\item{reduced}{If TRUE returns reduced result (no `X`, `i.best`, 
see 'return')}

\item{fun}{the functional form of the G function used in the approximation 
to neg-entropy in fastICA. Default value is "logcosh"}

\item{alg.typ}{parameter for fastICA(). If alg.typ == "deflation" the 
components are extracted one at a time. If alg.typ == "parallel" the 
components are extracted simultaneously. Default value is "deflation"}

\item{verbose}{logic TRUE or FALSE. Use TRUE for print process steps. 
Default value is FALSE}

\item{assay_string}{name of assay for `SummarizedExperiment` or `Seurat` 
input object `X`. Default value is NULL}
}
\value{
a list with
        \item{X}{input object}
        \item{nsamples, nfeatures}{dimension of X}
        \item{S, M}{consensus metagene and weight matrix}
        \item{ncomp}{number of components}
        \item{X_num}{input data in matrix format}
        \item{mr2}{mean R2 between rows of M}
        \item{stab}{stability, mean R2 between consistent columns of S in 
        multiple tries. Applicable only for `ntry` > 1}
        \item{i.best}{number of best iteration}
}
\description{
calculate consensus independent component analysis (ICA) 
Implements efficient ICA calculations.
}
\examples{
data("samples_data")
# Deconvolve into independent components
cica <- consICA(samples_data, ncomp=15, ntry=10, ncores=1, show.every=0)
# X = S * M, where S - independent signals matrix, M - weights matrix
dim(samples_data)
dim(cica$S)
dim(cica$M)
}
\seealso{
\code{\link[fastICA]{fastICA}}
}
\author{
Petr V. Nazarov
}
