% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_features.R
\name{compare_features}
\alias{compare_features}
\title{hotspot comparison by additional features}
\usage{
compare_features(data, regions, feature)
}
\arguments{
\item{data}{A dataframe containing the clinical features and
the mutation count. Dataframe must contain columns with the following names:
"Chromosome" <-- Chromosome number where the mutation is located
"Position" <-- Genomic position number where the mutation is located
"Sample" <-- Unique ID for each sample in dataset
"Gene" <-- Name of the gene which mutation is located in (optional)}

\item{regions}{a dataframe containing the chromosome, start
and end base pair position of each region of interest}

\item{feature}{A list containing all the features.}
}
\value{
A grid of all the violin plots for the categorical
data and scatter plot for the sequential data.
}
\description{
This function performs an exploratory data analysis
comparing the relationship between user-input features to
hotspot mutation burden.
}
\details{
This function is used to classify the features into
sequential features if values are numerical or classifies
them into #' categorical features. Sequential features are
compared to the mutation count using Pearson correlation.
Similarly, in categorical features either Wilcox or
Kruskal-Wallis test is used to compare between the groups
in the features based on the mutational count. Scatter plot
is used to represent the sequential features along with the
R and p-value from the pearson correlation. Violin plots are
used to plot the groups in the categorical data and Wilcox
or Kruskal-Wallis values are shown on the graph.
}
\examples{

data("compSPOT_example_mutations")
data("compSPOT_example_regions")
features <- c("AGE", "SEX", "ADJUVANT_TX", "SMOKING_HISTORY",
"TUMOR_VOLUME", "KI_67")
compare_features(data = compSPOT_example_mutations,
regions = compSPOT_example_regions, feature = features)

}
