% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addLink.R
\name{addLink}
\alias{addLink}
\title{Add a link on a compositional plot}
\usage{
addLink(
  DIplot,
  links,
  Views,
  samples,
  variable = NULL,
  Dims = c(1, 2),
  addLabel = FALSE,
  labPos = NULL,
  projColour = "grey",
  latentSize = 0.25
)
}
\arguments{
\item{DIplot}{A list with ggplot object where the links are to be added,
and data frames with coordinates (obtained by setting plot(..., returnCoords = TRUE))}

\item{links}{A matrix containing either feature names (two column matrix)
or approximate coordinates (four column matrix)}

\item{Views}{Indices or names of the views for which the links should be added}

\item{samples}{Sample names or approximate sample coordinates}

\item{variable}{Name of variable in environmental gradient for which link
should be plotted}

\item{Dims}{vector of length 2 referring to the model dimensions}

\item{addLabel}{A boolean, should arrow with label be plotted?}

\item{labPos}{The position of the label, as a numeric vector of length 2}

\item{projColour}{The colour of the projection, as character string}

\item{latentSize}{Size of the line from the origin to the latent variable dot}
}
\value{
A ggplot object with the links added
}
\description{
Add a link on a compositional plot
}
\examples{
data(Zhang)
\dontrun{
#Unconstrained
microMetaboInt = combi(
list("microbiome" = zhangMicrobio, "metabolomics" = zhangMetabo),
distributions = c("quasi", "gaussian"), compositional = c(TRUE, FALSE),
logTransformGaussian = FALSE, verbose = TRUE)
}
load(system.file("extdata", "zhangFits.RData", package = "combi"))
Plot = plot(microMetaboInt, samDf = zhangMetavars, samCol = "ABX",
 returnCoords = TRUE)
addLink(Plot, links = cbind("OTU0565b3","OTUa14fb5"), Views = 1,
 samples = c(1,1))
}
