% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{permuteDist}
\alias{permuteDist}
\title{permuteDist}
\usage{
permuteDist(co_gr, B = 100, mapping_fun = "k", group_by)
}
\arguments{
\item{co_gr}{GRanges or RangedSummarizedExperiment object that contains the
crossover counts for each marker interval across all samples.
Returned by \code{countCOs}}

\item{B}{integer the number of sampling times}

\item{mapping_fun}{character default to "k" (kosambi mapping function). It
can be one of the mapping functions: "k","h"}

\item{group_by}{the prefix for each group that we need to generate
distributions for(only when co_gr is a GRanges object). Or the column name
for `colData(co_gr)` that contains the
group factor (only when co_gr is a RangedSummarizedExperiment object)}
}
\value{
A list of three elements. `permutes` of length B with numeric
differences of permuted group differences,`observed_diff` the observed
genetic distances of two groups, `nSample`, the number of samples in the
first and second group.
}
\description{
Permutation test of two sample groups
}
\details{
It shuffles the group labels for the samples and calculate a difference
between two groups after shuffling.
}
\examples{
data(coCount)
perms <- permuteDist(coCount, group_by = "sampleGroup",B=10)
}
\author{
Ruqian Lyu
}
