% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-snp-den-track.R
\name{getSNPDensityTrack}
\alias{getSNPDensityTrack}
\title{getSNPDensityTrack}
\usage{
getSNPDensityTrack(
  chrom = "chr1",
  sampleName = "s1",
  path_loc = ".",
  nwindow = 80,
  plot_type = "hist",
  log = TRUE
)
}
\arguments{
\item{chrom}{the chromosome}

\item{sampleName}{the sample name, which is the prefix of sscocaller's output
files}

\item{path_loc}{the path prefix to the output files from sscocaller including
"*_totalCount.mtx" and "_altCount.mtx"}

\item{nwindow}{the number of windows for binning the chromosome}

\item{plot_type, }{the DataTrack plot type, default to be `hist`}

\item{log, }{whether the histogram of SNP density should be plotted on log
scale (log10)}
}
\value{
DataTrack object plotting the SNP density histogram
}
\description{
Generate the SNP density DataTrack (from `Gviz`) for selected chromosome
}
\examples{
demo_path <- system.file("extdata",package = "comapr")
snp_track <- getSNPDensityTrack(chrom ="chr1",
                               path_loc = demo_path,
                               sampleName = "s1")
}
\author{
Ruqian Lyu
}
