% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCellAFTrack.R, R/getCellCORange.R
\name{getCellAFTrack}
\alias{getCellAFTrack}
\title{getCellAFTrack
Generates the DataTracks for plotting AF and crossover regions}
\usage{
getCellAFTrack(
  chrom = "chr1",
  path_loc = "./output/firstBatch/WC_522/",
  sampleName = "WC_522",
  nwindow = 80,
  barcodeFile,
  cellBarcode,
  co_count,
  snp_track = NULL,
  chunk = 1000L
)

getCellAFTrack(
  chrom = "chr1",
  path_loc = "./output/firstBatch/WC_522/",
  sampleName = "WC_522",
  nwindow = 80,
  barcodeFile,
  cellBarcode,
  co_count,
  snp_track = NULL,
  chunk = 1000L
)
}
\arguments{
\item{chrom, }{the chromosome}

\item{path_loc, }{the path prefix to the output files from sscocaller including
"*_totalCount.mtx" and "_altCount.mtx"}

\item{sampleName, }{the sample name, which is the prefix of sscocaller's output
files}

\item{nwindow, }{the number of windows for binning the chromosome}

\item{barcodeFile, }{the barcode file containing the list of cell barcodes used
as the input file for sscocaller}

\item{cellBarcode, }{the selected cell barcode}

\item{co_count, }{`GRange` or `RangedSummarizedExperiment` object,
returned by \code{countCO} that contains the crossover intervals and the number
of crossovers in each cell.}

\item{snp_track, }{the SNP position track which is used for obtaining the SNP
chromosome locations. It could be omitted and the SNP positions will be acquired
from the "*_snpAnnot.txt" file.}

\item{chunk, }{An integer scalar indicating the chunk size to use,
i.e., number of rows to read at any one time.}
}
\value{
The DataTrack object defined in \code{\link[Gviz]{DataTrack}}

The DataTrack object defined in \code{\link[Gviz]{DataTrack}}
}
\description{
It plots the raw alternative allele frequencies and highlight the crossover
regions for the selected cell.

It plots the raw alternative allele frequencies and highlight the crossover
regions for the selected cell.
}
\examples{
demo_path <-paste0(system.file("extdata",package = "comapr"),"/")
s1_rse_state <- readHapState("s1",chroms=c("chr1"),
                             path=demo_path,barcodeFile=NULL,minSNP = 0,
                             minlogllRatio = 50,
                             bpDist = 100,maxRawCO=10,
                             minCellSNP = 0)
s1_counts <- countCOs(s1_rse_state)
af_co_tracks <- getCellAFTrack(chrom ="chr1",
                               path_loc = demo_path,
                               sampleName = "s1",
                               barcodeFile = paste0(demo_path,
                                                    "s1_barcodes.txt"),
                               cellBarcode = "BC1",
                               co_count = s1_counts)

demo_path <-paste0(system.file("extdata",package = "comapr"),"/")
s1_rse_state <- readHapState("s1",chroms=c("chr1"),
                             path=demo_path,barcodeFile=NULL,minSNP = 0,
                             minlogllRatio = 50,
                             bpDist = 100,maxRawCO=10,
                             minCellSNP = 0)
s1_counts <- countCOs(s1_rse_state)
af_co_tracks <- getCellAFTrack(chrom ="chr1",
                               path_loc = demo_path,
                               sampleName = "s1",
                               barcodeFile = paste0(demo_path,
                                                    "s1_barcodes.txt"),
                               cellBarcode = "BC1",
                               co_count = s1_counts)

}
\author{
Ruqian Lyu
}
