% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reformat-geno-mt.R
\name{fill_fail}
\alias{fill_fail}
\title{Infer the genotype of failed SNPs
If we have a \code{Fail} in the genotype data and the \code{Fail} in a block
of either Home_alt, or Het, we fill in the \code{Fail}s using values of the
ones adjacent to it, otherwise they remain as "Fail" to indicate missing
values.}
\usage{
fill_fail(s_gt, fail = "Fail", chr = NULL)
}
\arguments{
\item{s_gt, }{a column of labelled genotypes}

\item{fail, }{the string that is used for encoding failed genotype results,
default to \code{Fail}}

\item{chr, }{the factor vector indicating which chromosomes the markers are
on, default to \code{NULL} which means the input markers are all on the same
chromosome.}
}
\value{
a vector of genotypes with Failed genotype imputed or changed to `NA` if not
imputable
}
\description{
Infer the genotype of failed SNPs
If we have a \code{Fail} in the genotype data and the \code{Fail} in a block
of either Home_alt, or Het, we fill in the \code{Fail}s using values of the
ones adjacent to it, otherwise they remain as "Fail" to indicate missing
values.
}
\author{
Ruqian Lyu
}
\keyword{internal}
