% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineHapState.R
\name{combineHapState}
\alias{combineHapState}
\title{combineHapState}
\usage{
combineHapState(rse1, rse2, groupName = c("Sample1", "Sample2"))
}
\arguments{
\item{rse1, }{the first `RangedSummarizedExperiment`}

\item{rse2, }{the second `RangedSummarizedExperiment`}

\item{groupName, }{a character vector of length 2 that contains the first and
the second group's names}
}
\value{
A `RangedSummarizedExperiment` that contains the cells and SNPs in
both `rse`
}
\description{
combine two `RangedSummarizedExperiment` objects, each contains the haplotype
state for a list of SNPs across a set of cells. The combined result will have
cells from two individuals and merged list of SNPs from the two.
}
\examples{
BiocParallel::register(BiocParallel::SnowParam(workers = 1))
demo_path <- paste0(system.file("extdata",package = "comapr"),"/")
s1_rse_state <- readHapState("s1",chroms=c("chr1"),
                             path=demo_path,barcodeFile=NULL,minSNP = 0,
                             minlogllRatio = 50,
                             bpDist = 100,maxRawCO=10,
                             minCellSNP = 1)

s2_rse_state <- readHapState("s2",chroms=c("chr1"),
                             path=demo_path,
                             barcodeFile=paste0(demo_path,"s2_barcodes.txt"),
                             minSNP = 0,
                             minlogllRatio = 50,
                             bpDist = 100,maxRawCO=10,
                             minCellSNP = 1)
sb <- combineHapState(s1_rse_state,s2_rse_state)

}
\author{
Ruqian Lyu
}
