% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genecl_class.R
\docType{class}
\name{genecl-class}
\alias{genecl-class}
\title{An S4 class to represent co-expressed gene}
\description{
An S4 class to represent co-expressed gene
}
\section{Slots}{

\describe{
\item{\code{mat}}{Differentially expressed gene expression profilings. Either a 
numeric matrix, a data.frame, or an ExpressionSet object. Data frames must
contain all numeric columns. In all cases, the rows are the items to be 
clustered (e.g., genes), and the columns are the samples.}

\item{\code{clusterObjs}}{a list contains clustering results.}

\item{\code{Distmat}}{the distance matrix.}

\item{\code{clMethods}}{clustering method.}

\item{\code{labels}}{the label of genes}

\item{\code{nClust}}{A numeric vector giving the numbers of clusters to be 
evaluated. e.g., 2:6 would evaluate the number of clusters ranging from 
2 to 6.}

\item{\code{metric}}{the distance measure to be used. It must be one of 
"euclidean","maximum", "manhattan", "canberra", "binary", 
"pearson", "abspearson", "correlation", "abscorrelation", 
"spearman" or "kendall". Any unambiguous substring can be 
given. In detail, please reference the parameter method in 
amap::Dist. Some of the cluster methods could use only part 
of the metric. Please reference the manual of cogena.}

\item{\code{method}}{For hierarchical clustering (hclust and agnes), the 
agglomeration method used. The default is "complete". Available 
choices are "ward", "single", "complete", and "average".}

\item{\code{ncore}}{the number of cores used.}

\item{\code{call}}{the called function}
}}

