% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\docType{methods}
\name{enrichment}
\alias{enrichment}
\alias{enrichment,cogena-method}
\alias{enrichment,cogena_methods}
\title{get the enrichment table from a cogena object.}
\usage{
enrichment(
  object,
  method,
  nCluster,
  CutoffNumGeneset = Inf,
  CutoffPVal = 0.05,
  orderMethod = "max",
  roundvalue = TRUE,
  add2 = FALSE
)

\S4method{enrichment}{cogena}(
  object,
  method,
  nCluster,
  CutoffNumGeneset = Inf,
  CutoffPVal = 0.05,
  orderMethod = "max",
  roundvalue = TRUE,
  add2 = TRUE
)
}
\arguments{
\item{object}{a genecl or cogena object}

\item{method}{as clMethods in genecl function}

\item{nCluster}{as nClust in cogena function.}

\item{CutoffNumGeneset}{the cut-off of the number of gene sets in the 
return table}

\item{CutoffPVal}{the cut-off of p-value. The default is 0.05.}

\item{orderMethod}{the order method, default is max, other options are 
"mean", "all", "I", "II" or a number meaning the ith cluster.}

\item{roundvalue}{The default is TRUE. whether or not round the data. 
such as round(1.54, 1)=1.5}

\item{add2}{enrichment score for add Up and Down reuglated genes.}
}
\value{
a matrix with clusters in row and gene-sets in column.
}
\description{
get the enrichment table from a cogena object with certain clustering 
methods and number of clusters.
}
\details{
orderMethod:
\itemize{
\item max. ordered by the max value in clusters beside all
\item mean. ordered by the mean value in clusters beside all
\item All. ordered by all genes
\item I. ordered by the I cluster in two clusters (Up or Down-regulated, add2 should be TRUE)
\item II. ordered by the II cluster in two clusters (Up or Down-regulated, add2 should be TRUE)
\item a character number. like "3".
}
}
\examples{
data(Psoriasis)
annofile <- system.file("extdata", "c2.cp.kegg.v7.01.symbols.gmt.xz", 
package="cogena")

\dontrun{
genecl_result <- coExp(DEexprs, nClust=2:3, clMethods=c("hierarchical","kmeans"), 
    metric="correlation", method="complete", ncore=2, verbose=TRUE)

clen_res <- clEnrich(genecl_result, annofile=annofile, sampleLabel=sampleLabel)

enrichment.table1 <- enrichment(clen_res, "kmeans", "3")
enrichment.table2 <- enrichment(clen_res, "kmeans", "3", 
CutoffNumGeneset=10, orderMethod="mean")
}

}
