% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetCpGsInRegion.R
\name{GetCpGsInRegion}
\alias{GetCpGsInRegion}
\title{Extract probe IDs for CpGs located in a genomic region}
\usage{
GetCpGsInRegion(
  regionName_char,
  region_gr = NULL,
  genome = c("hg19", "hg38"),
  arrayType = c("450k", "EPIC"),
  manifest_gr = NULL,
  ignoreStrand = TRUE
)
}
\arguments{
\item{regionName_char}{character string with location information for one
region in the format \code{"chrxx:xxxxxx-xxxxxx"}}

\item{region_gr}{An object of class \code{\link[GenomicRanges]{GRanges}} with
location information for one region. If this argument is NULL, then the 
region in \code{regionName_char} is used.}

\item{genome}{human genome of reference hg19 (default) or hg38}

\item{arrayType}{Type of array, 450k or EPIC}

\item{manifest_gr}{A GRanges object with the genome manifest (as returned by
\code{\link[ExperimentHub]{ExperimentHub}} or by
\code{\link{ImportSesameData}}). This function by default ignores this
argument in favour of the \code{genome} and \code{arrayType} arguments.}

\item{ignoreStrand}{Whether strand can be ignored, default is TRUE}
}
\value{
vector of CpG probe IDs mapped to the genomic region
}
\description{
Extract probe IDs for CpGs located in a genomic region
}
\examples{
   
   myRegion_gr <- RegionsToRanges("chr22:18267969-18268249")
   
   GetCpGsInRegion(
     region_gr = myRegion_gr,
     genome = "hg19",
     arrayType = "450k",
     ignoreStrand = TRUE
   )
   
}
