% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{robust_zscore}
\alias{robust_zscore}
\title{Compoute robust z-scores}
\usage{
robust_zscore(x, min_mad = 1e-06, ...)
}
\arguments{
\item{x}{numeric vector to z-score}

\item{min_mad}{the minimum allowed MAD,
useful for avoiding division by very
small numbers}

\item{...}{further options to median, max functions}
}
\value{
transformed version of x
}
\description{
robust zscore implementation
takes in a 1D vector, returns 1D vector
after computing robust zscores
rZ = (x-med(x))/mad(x)
}
\examples{
(x <- rnorm(25))
(robust_zscore(x))

# with min_mad
(robust_zscore(x, min_mad=1e-4))

}
