% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/utils.R
\name{annotate.gct}
\alias{annotate.gct}
\alias{annotate_gct}
\alias{annotate_gct,GCT-method}
\title{Add annotations to a GCT object}
\usage{
annotate.gct(...)

annotate_gct(g, annot, dim = "row", keyfield = "id")

\S4method{annotate_gct}{GCT}(g, annot, dim = "row", keyfield = "id")
}
\arguments{
\item{...}{arguments passed on to \code{annotate_gct}}

\item{g}{a GCT object}

\item{annot}{a \code{\link{data.frame}} or path to text table of annotations}

\item{dim}{either 'row' or 'column' indicating which dimension
of \code{g} to annotate}

\item{keyfield}{the character name of the column in \code{annot} that 
matches the row or column identifiers in \code{g}}
}
\value{
a GCT object with annotations applied to the specified
  dimension
}
\description{
Given a GCT object and either a \code{\link{data.frame}} or
a path to an annotation table, apply the annotations to the
gct using the given \code{keyfield}.
}
\examples{
gct_path <- system.file("extdata", "modzs_n25x50.gctx", package="cmapR")
# read the GCT file, getting the matrix only
g <- parse_gctx(gct_path, matrix_only=TRUE)
# separately, read the column annotations and then apply them using
# annotate_gct
cdesc <- read_gctx_meta(gct_path, dim="col")
g <- annotate_gct(g, cdesc, dim="col", keyfield="id")


}
\seealso{
Other GCT utilities: 
\code{\link{melt.gct}()},
\code{\link{merge.gct}()},
\code{\link{rank.gct}()},
\code{\link{subset.gct}()}
}
\concept{GCT utilities}
