% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calc_distance}
\alias{calc_distance}
\title{Distance calculations for spatial coord}
\usage{
calc_distance(
  coord,
  metadata,
  cluster_col = "cluster",
  collapse_to_cluster = FALSE
)
}
\arguments{
\item{coord}{dataframe or matrix of spatial coordinates, cell barcode as rownames}

\item{metadata}{data.frame or vector containing cluster assignments per cell.
Order must match column order in supplied matrix. If a data.frame
provide the cluster_col parameters.}

\item{cluster_col}{column in metadata with cluster number}

\item{collapse_to_cluster}{instead of reporting min distance to cluster per cell, summarize to cluster level}
}
\value{
min distance matrix
}
\description{
Distance calculations for spatial coord
}
\examples{
cbs <- paste0("cb_", 1:100)

spatial_coords <- data.frame(
    row.names = cbs,
    X = runif(100),
    Y = runif(100)
)
group_ids <- sample(c("A", "B"), 100, replace = TRUE)
dist_res <- calc_distance(
    spatial_coords,
    group_ids
)
}
