% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllHelper.R
\name{ClusterExperiment-methods}
\alias{ClusterExperiment-methods}
\alias{show}
\alias{show,ClusterExperiment-method}
\alias{transformation,ClusterExperiment-method}
\alias{transformation}
\alias{transformation<-,ClusterExperiment,function-method}
\alias{transformation<-}
\alias{nClusterings,ClusterExperiment-method}
\alias{nClusterings}
\alias{nClusters,ClusterExperiment-method}
\alias{nClusters}
\alias{nFeatures,ClusterExperiment-method}
\alias{nFeatures}
\alias{nSamples,ClusterExperiment-method}
\alias{nSamples}
\alias{clusterMatrixNamed,ClusterExperiment-method}
\alias{clusterMatrixNamed}
\alias{clusterMatrixColors,ClusterExperiment-method}
\alias{clusterMatrixColors}
\alias{clusterMatrix,ClusterExperiment-method}
\alias{clusterMatrix}
\alias{primaryCluster,ClusterExperiment-method}
\alias{primaryCluster}
\alias{primaryClusterIndex,ClusterExperiment-method}
\alias{primaryClusterIndex}
\alias{primaryClusterLabel,ClusterExperiment-method}
\alias{primaryClusterLabel}
\alias{primaryClusterNamed,ClusterExperiment-method}
\alias{primaryClusterNamed}
\alias{primaryClusterType,ClusterExperiment-method}
\alias{primaryClusterType}
\alias{primaryClusterIndex<-,ClusterExperiment,numeric-method}
\alias{primaryClusterIndex<-}
\alias{dendroClusterIndex,ClusterExperiment-method}
\alias{dendroClusterIndex}
\alias{coClustering,ClusterExperiment-method}
\alias{coClustering}
\alias{coClustering<-,ClusterExperiment,matrix-method}
\alias{coClustering<-}
\alias{coClustering<-,ClusterExperiment,dsCMatrix-method}
\alias{coClustering<-,ClusterExperiment,numeric-method}
\alias{clusterTypes,ClusterExperiment-method}
\alias{clusterTypes}
\alias{clusteringInfo,ClusterExperiment-method}
\alias{clusteringInfo}
\alias{clusterLabels,ClusterExperiment-method}
\alias{clusterLabels}
\alias{clusterLabels<-,ClusterExperiment,character-method}
\alias{clusterLabels<-}
\alias{clusterLegend,ClusterExperiment-method}
\alias{clusterLegend}
\alias{clusterLegend<-,ClusterExperiment,list-method}
\alias{clusterLegend<-}
\alias{orderSamples,ClusterExperiment-method}
\alias{orderSamples}
\alias{orderSamples<-,ClusterExperiment,numeric-method}
\alias{orderSamples<-}
\alias{clusterTypes<-,ClusterExperiment,character-method}
\alias{clusterTypes<-}
\alias{addToColData,ClusterExperiment-method}
\alias{addToColData}
\alias{colDataClusters,ClusterExperiment-method}
\alias{colDataClusters}
\title{Helper methods for the ClusterExperiment class}
\usage{
\S4method{show}{ClusterExperiment}(object)

\S4method{transformation}{ClusterExperiment}(x)

\S4method{transformation}{ClusterExperiment,function}(object) <- value

\S4method{nClusterings}{ClusterExperiment}(x)

\S4method{nClusters}{ClusterExperiment}(x, ignoreUnassigned = TRUE)

\S4method{nFeatures}{ClusterExperiment}(x)

\S4method{nSamples}{ClusterExperiment}(x)

\S4method{clusterMatrixNamed}{ClusterExperiment}(x, whichClusters = "all")

\S4method{clusterMatrixColors}{ClusterExperiment}(x, whichClusters = "all")

\S4method{clusterMatrix}{ClusterExperiment}(x, whichClusters)

\S4method{primaryCluster}{ClusterExperiment}(x)

\S4method{primaryClusterIndex}{ClusterExperiment}(x)

\S4method{primaryClusterLabel}{ClusterExperiment}(x)

\S4method{primaryClusterNamed}{ClusterExperiment}(x)

\S4method{primaryClusterType}{ClusterExperiment}(x)

\S4method{primaryClusterIndex}{ClusterExperiment,numeric}(object) <- value

\S4method{dendroClusterIndex}{ClusterExperiment}(x)

\S4method{coClustering}{ClusterExperiment}(x)

\S4method{coClustering}{ClusterExperiment,matrix}(object) <- value

\S4method{coClustering}{ClusterExperiment,dsCMatrix}(object) <- value

\S4method{coClustering}{ClusterExperiment,numeric}(object) <- value

\S4method{clusterTypes}{ClusterExperiment}(x)

\S4method{clusteringInfo}{ClusterExperiment}(x)

\S4method{clusterLabels}{ClusterExperiment}(x)

\S4method{clusterLabels}{ClusterExperiment,character}(object) <- value

\S4method{clusterLegend}{ClusterExperiment}(x)

\S4method{clusterLegend}{ClusterExperiment,list}(object) <- value

\S4method{orderSamples}{ClusterExperiment}(x)

\S4method{orderSamples}{ClusterExperiment,numeric}(object) <- value

\S4method{clusterTypes}{ClusterExperiment,character}(object) <- value

\S4method{addToColData}{ClusterExperiment}(object, ...)

\S4method{colDataClusters}{ClusterExperiment}(
  object,
  whichClusters = "primary",
  useNames = TRUE,
  makeFactor = TRUE,
  ...
)
}
\arguments{
\item{x, object}{a ClusterExperiment object.}

\item{value}{The value to be substituted in the corresponding slot. See the
slot descriptions in \code{\link{ClusterExperiment}} for details on what
objects may be passed to these functions.}

\item{ignoreUnassigned}{logical. If true, ignore the clusters with -1 or -2
assignments in calculating the number of clusters per clustering.}

\item{whichClusters}{argument that can be either numeric or character vector
indicating the clusterings to be used. See details of \code{\link{getClusterIndex}}.}

\item{...}{For \code{addToColData}, arguments passed to
\code{colDataClusters}.}

\item{useNames}{for \code{tableClusters}, whether the output should be tabled
with names (\code{useNames=TRUE}) or ids (\code{useNames=FALSE})}

\item{makeFactor}{logical for \code{colDataClusters}. If TRUE the clustering
will be added to the \code{colData} slot as a factor. If FALSE, the
clustering will be added to the \code{colData} slot as a character vector
if \code{useNames=TRUE} and as a numeric vector if \code{useNames=FALSE}.}
}
\value{
\code{transformation} prints the function used to transform the data
prior to clustering.

\code{nClusterings} returns the number of clusterings (i.e., ncol of
clusterMatrix).

\code{nClusters} returns the number of clusters per clustering

\code{nFeatures} returns the number of features (same as `nrow`).

\code{nSamples} returns the number of samples (same as `ncol`).

\code{clusterMatrixNamed} returns a matrix with cluster labels.

\code{clusterMatrixColors} returns the matrix with all the
  clusterings, using the internally stored colors for each cluster

\code{clusterMatrix} returns the matrix with all the clusterings.

\code{primaryCluster} returns the primary clustering (as numeric).

\code{primaryClusterIndex} returns/sets the primary clustering index
(i.e., which column of clusterMatrix corresponds to the primary clustering).

\code{primaryClusterIndex} returns/sets the primary clustering index
(i.e., which column of clusterMatrix corresponds to the primary clustering).

\code{primaryClusterNamed} returns the primary cluster (using cluster
labels).

\code{primaryClusterIndex} returns/sets the primary clustering index
(i.e., which column of clusterMatrix corresponds to the primary clustering).

\code{dendroClusterIndex} returns/sets the clustering index 
of the clusters used to create dendrogram
(i.e., which column of clusterMatrix corresponds to the clustering).

\code{coClustering} returns/sets the co-clustering matrix.

\code{clusterTypes} returns/sets the clusterTypes slot.

\code{clusteringInfo} returns the clusterInfo slot.

\code{clusterLabels} returns/sets the column names of the
  clusterMatrix slot.

\code{clusterLegend} returns/sets the clusterLegend slot.

\code{orderSamples} returns/sets the orderSamples slot.

\code{addToColData} returns a \code{ClusterExperiment} object
with the clusterings in clusterMatrix slot added to the \code{colData} slot

\code{colDataClusters} returns a \code{DataFrame} object
that has the clusterings in clusterMatrix slot added to the 
\code{DataFrame} in the \code{colData} slot
}
\description{
This is a collection of helper methods for the ClusterExperiment
  class.
}
\details{
Note that redefining the transformation function via
  \code{transformation(x)<-} will check the validity of the transformation on
  the data assay. If the assay is large, this may be time consuming. Consider
  using a call to ClusterExperiment, which has the option as to whether to
  check the validity of the transformation.
}
\examples{
# load data:
data(rsecFluidigm)
show(rsecFluidigm)
#Number of clusterings
nClusterings(rsecFluidigm)
# Number of clusters per clustering
nClusters(rsecFluidigm)
# Number of features/samples
nSamples(rsecFluidigm)
nFeatures(rsecFluidigm)
# retrieve all clustering assignments
# (either as cluster ids, cluster names or cluster colors)
head(clusterMatrix(rsecFluidigm)[,1:5])
head(clusterMatrixNamed(rsecFluidigm)[,1:5])
head(clusterMatrixColors(rsecFluidigm)[,1:5])
# clustering Types/Labels
clusterTypes(rsecFluidigm)
clusterLabels(rsecFluidigm)
# Add a clustering assignment to the colData of the object
# (useful if working with function that relies on colData)
colData(rsecFluidigm)
test<-addToColData(rsecFluidigm,whichCluster="primary")
colData(test)
}
