% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findIsotopes.R
\name{getIsotopes}
\alias{getIsotopes}
\title{Annotate isotopes}
\usage{
getIsotopes(anclique, maxCharge = 3, maxGrade = 2, ppm = 10, isom = 1.003355)
}
\arguments{
\item{anclique}{An 'anClique' object with clique groups computed}

\item{maxCharge}{Maximum charge considered when we test two
features to see whether they are isotopes}

\item{maxGrade}{The maximum number of isotopes apart from the
monoisotopic mass. A 'maxGrade' = 2 means than we have the
monoisotopic mass, first isotope and second isotope}

\item{ppm}{Relative error in ppm to consider that two features
have the mass difference of an isotope}

\item{isom}{The mass difference of the isotope}
}
\value{
It returns an 'anClique' object with isotope annotation.
it adds the column 'isotope' to the peaklist in the anClique object
}
\description{
This function annotates features that are carbon
isotopes based on m/z and intensity data. The monoisotopic
mass has to be more intense than the first isotope, the first
isotope more intense than the second isotope and so one so forth.
Isotopes are annotated within each clique group.
}
\examples{
data(ex.cliqueGroups)
show(ex.cliqueGroups)
ex.isoAn <- getIsotopes(ex.cliqueGroups)
show(ex.isoAn)
}
\seealso{
\code{\link{getCliques}}
}
