% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-motifProfile.R
\name{motifProfile}
\alias{motifProfile}
\title{motifProfile for the GRanges objects}
\usage{
motifProfile(
    object,
    motif = NA,
    genome = NA,
    fraction = TRUE,
    title = "Motif Profile",
    flanking = 10
)
}
\arguments{
\item{object}{A GRanges object which should contains all the peaks that you
want to check}

\item{motif}{A character string which use the IUPAC nucleotide code, e.g.
DRACH, TTAGGG.}

\item{genome}{The name of the full genome sequences package in the
Bioconductor, e.g. "BSgenome.Mmusculus.UCSC.mm10". You should
install the package before running this function.}

\item{fraction}{A logical vector (TRUE or FALSE) that the result should be
presented in fraction or number.}

\item{title}{The main title for the output meta gene profile plot.}

\item{flanking}{The size of the flanking windows that you would like to
check. Flanking=5 will give you the result of the 10+1nt
windows around the center of peaks.}
}
\value{
A list object, the list 1 contains the information of the
    frequency of specified motif around the center of peaks. The list 2
    includes the plot of motifProfile.
}
\description{
An function to plot the frequency or fraction of the interested
    motif around the center of input peaks.
}
\examples{
## Load the test data and get the path to the test gff3 file
testpath <- system.file("extdata", package = "cliProfiler")
test <- readRDS(file.path(testpath, "test.rds"))
test_gff3 <- file.path(testpath, "annotation_test.gff3")

## Please make sure that the correct BSgenome package have installed before
## running motifProfile. For example,library("BSgenome.Mmusculus.UCSC.mm10")
## would be required for the mouse data.

output <- motifProfile(test,
    motif = "DRACH",
    genome = "BSgenome.Mmusculus.UCSC.mm10",
    flanking = 20
)
}
\author{
You Zhou, Kathi Zarnack
}
