% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMotifs.R
\name{mergeMotifs}
\alias{mergeMotifs}
\title{Group motifs shared by multiple RBPs}
\usage{
mergeMotifs(motifs)
}
\arguments{
\item{motifs}{A data frame generated with \code{\link{getMotifs}}.}
}
\value{
A data frame.
}
\description{
A same RBP can recognize multiple motifs, the function
mergeMotifs() groups all the motifs found for each RBP and report the
total counts.
}
\examples{
# Load data frame containing detected back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Example with the first back-spliced junctions.
# Multiple back-spliced junctions can also be analyzed at the same time.

# Annotate detected back-spliced junctions
annotatedBSJs <- annotateBSJs(mergedBSJunctions[1, ], gtf)

# Get genome
genome <- BSgenome::getBSgenome("BSgenome.Hsapiens.UCSC.hg19")

# Retrieve target sequences
targets <- getSeqsFromGRs(
    annotatedBSJs,
    genome,
    lIntron = 200,
    lExon = 10,
    type = "ie"
    )

# Get motifs
motifs <-
getMotifs(
    targets,
    width = 6,
    species = "Hsapiens",
    rbp = TRUE,
   reverse = FALSE)

# Group motifs
mergedMotifs <- mergeMotifs(motifs)

}
