% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEdgerRes.R
\name{getEdgerRes}
\alias{getEdgerRes}
\title{Differential circRNA expression analysis adapted from EdgeR}
\usage{
getEdgerRes(
  backSplicedJunctions,
  condition,
  normMethod = "TMM",
  pAdjustMethod = "BH",
  pathToExperiment = NULL
)
}
\arguments{
\item{backSplicedJunctions}{A data frame containing the back-spliced junction
coordinates and counts in each analyzed sample.
See \code{\link{getBackSplicedJunctions}} and \code{\link{mergeBSJunctions}}
(to group circRNA detected by multiple detection tools) on how to generated
this data frame.}

\item{condition}{A string specifying which conditions to compare. Only 2
conditions at the time can be analyzed. Separate the 2 conditions with a
dash, e.g. A-B. Use the same name used in column condition in experiment.txt.
log2FC calculation is perfomed by comparing the condition positioned
forward against the condition positioned backward in the alphabet.
E.g. if there are 2 conditions A and B then a negative log2FC means that
in condition B there is a downregulation of the corresponding circRNA.
If a positive log2FC is found means that there is an upregulation in
condition B of that circRNA.}

\item{normMethod}{A character string specifying the normalization method to
be used. It can be "TMM","RLE","upperquartile" or"none".  The value given
to the method argument is given to the \code{\link[edgeR]{calcNormFactors}}
used internally. Deafult value is "TMM".}

\item{pAdjustMethod}{A character string stating the method used to adjust
p-values for multiple testing. See \code{\link[stats]{p.adjust}}.
Deafult value is "BH".}

\item{pathToExperiment}{A string containing the path to the experiment.txt
file. The file experiment.txt contains the experiment design information.
It must have at least 3 columns with headers:
\describe{
\item{label:}{(1st column) - unique names of the samples (short but informative).}
\item{fileName:}{(2nd column) - name of the input files - e.g. circRNAs_X.txt, where
x can be can be 001, 002 etc.}
\item{group:}{ (3rd column) - biological conditions - e.g. A or B; healthy or diseased
if you have only 2 conditions.}
}

By default pathToExperiment is set to NULL and the file it is searched in
the working directory. If experiment.txt is located in a different directory
then the path needs to be specified.}
}
\value{
A data frame.
}
\description{
The helper functions edgerRes() identifies
differentially expressed circRNAs. The latter uses respectively the R
Bioconductor packages EdgeR which implements a beta-binomial model to model
changes in circRNA expression. The info reported in  experiment.txt file
are needed for differential expression analysis.
}
\examples{
# Load a data frame containing detected back-spliced junctions
data("mergedBSJunctions")

pathToExperiment <- system.file("extdata", "experiment.txt",
    package ="circRNAprofiler")

# Filter circRNAs
filteredCirc <- filterCirc(
    mergedBSJunctions,
    allSamples = FALSE,
    min = 5,
    pathToExperiment)

# Find differentially expressed circRNAs
deseqResBvsA <- getEdgerRes(
    filteredCirc,
    condition = "A-B",
    normMethod = "TMM",
    pAdjustMethod = "BH",
    pathToExperiment)


}
