% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateSNPsGWAS.R
\name{annotateSNPsGWAS}
\alias{annotateSNPsGWAS}
\title{Annotate GWAS SNPs}
\usage{
annotateSNPsGWAS(
  targets,
  assembly = "hg19",
  makeCurrent = TRUE,
  pathToTraits = NULL
)
}
\arguments{
\item{targets}{A list containing the target regions to analyze.
It can be generated with \code{\link{getSeqsFromGRs}}.}

\item{assembly}{A string specifying the human genome assembly.
Possible options are hg38 or hg19. Current image for GWAS SNPS coordinates
is hg38. If hg19 is specified SNPs coordinates are realtime liftOver to
hg19 coordinates.}

\item{makeCurrent}{A logical specifying whether to download the
current image of the GWAS catalog.  If TRUE is specified, the function
\code{\link[gwascat]{makeCurrentGwascat}} from the gwascat package is used 
to get the more recent image (slow). Default value is TRUE.
If FALSE is specified the image data(ebicat37) or data(ebicat38) are used.
NOTE: This second option is not available anymore since data(ebicat37) or
data(ebicat38) from gwascat are deprecated.}

\item{pathToTraits}{A string containing the path to the traits.txt file.
The file traits.txt contains diseases/traits specified by the user. It must
have one column with header id. By default pathToTraits is set to NULL and
the file it is searched in the working directory. If traits.txt is located
in a different directory then the path needs to be specified. If this file is
absent or empty SNPs associated with all diseases/traits in
the GWAS catalog are considered in the SNPs analysis.}
}
\value{
A list.
}
\description{
The function annotateSNPsGWAS() annotates GWAS SNPs located
in the region flanking the back-spliced junctions of each circRNA.
SNPs information including the corresponding genomic coordinates are
retrieved from the GWAs catalog database.
The user can restric the analysis to specific traits/diseases. These must go
in the file traits.txt. If this file is absent or empty, all traits in the
GWAS catalog are considered in the analysis.
An empty list is returned if none overlapping SNPs are found.
}
\examples{
# Load data frame containing detected back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Annotate the first back-spliced junctions
annotatedBSJs <- annotateBSJs(mergedBSJunctions[1, ], gtf)

# Get genome
if (requireNamespace("BSgenome.Hsapiens.UCSC.hg19", quietly = TRUE)){
genome <- BSgenome::getBSgenome("BSgenome.Hsapiens.UCSC.hg19")

# Retrieve targets
targets <- getSeqsFromGRs(
    annotatedBSJs,
    genome,
    lIntron = 200,
    lExon = 10,
    type = "ie"
    )

# Annotate GWAS SNPs - slow

#snpsGWAS <- annotateSNPsGWAS(targets, makeCurrent = TRUE, assembly = "hg19")

}


}
