% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateBSJs.R
\name{annotateBSJs}
\alias{annotateBSJs}
\title{Annotate circRNA features.}
\usage{
annotateBSJs(
  backSplicedJunctions,
  gtf,
  isRandom = FALSE,
  pathToTranscripts = NULL
)
}
\arguments{
\item{backSplicedJunctions}{A data frame containing the back-spliced junction
coordinates (e.g. detected or randomly selected).
For detected back-spliced junctions see \code{\link{getBackSplicedJunctions}}
and \code{\link{mergeBSJunctions}} (to group circRNAs detected by multiple
detection tools). For randomly selected back-spliced junctions see
\code{\link{getRandomBSJunctions}}.}

\item{gtf}{A data frame containing genome annotation information. It can be
generated with \code{\link{formatGTF}}.}

\item{isRandom}{A logical indicating whether the back-spliced junctions have
been randomly generated with \code{\link{getRandomBSJunctions}}.
Deafult value is FALSE.}

\item{pathToTranscripts}{A string containing the path to the transcripts.txt
file. The file transcripts.txt contains the transcript ids of the
circRNA host gene to analyze. It must have one column with header id.
By default pathToTranscripts is set to NULL and the file it is searched in
the working directory. If transcripts.txt is located in a different directory
then the path needs to be specified. If this file is empty or absent the
longest transcript of the circRNA host gene containing the back-spliced
junctions are considered in the annotation analysis.}
}
\value{
A data frame.
}
\description{
The function annotateBSJs() annotates the circRNA structure
and the introns flanking the corresponding back-spliced junctions.
The genomic features are extracted from the user provided gene annotation.
}
\examples{
# Load a data frame containing detected back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Annotate the first back-spliced junctions
annotatedBSJs <- annotateBSJs(mergedBSJunctions[1, ], gtf)

}
