% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate_by_cell_bin}
\alias{aggregate_by_cell_bin}
\title{Aggregate count CDS by groups of cells}
\usage{
aggregate_by_cell_bin(cds, group_col)
}
\arguments{
\item{cds}{A CDS object to be aggregated}

\item{group_col}{The name of the column in the \code{pData} table that
indicates the cells assignment to its aggregate bin.}
}
\value{
A count cds aggregated by group_col
}
\description{
Aggregates a CDS based on an indicator column in the \code{pData} table
}
\details{
This function takes an input CDS object and collapses cells based
  on a column in the \code{pData} table by summing the values within the
  cell group.
}
\examples{
  data("cicero_data")
  #input_cds <- make_atac_cds(cicero_data, binarize = TRUE)
  #pData(input_cds)$cell_subtype <- rep(1:10, times=20)
  #binned_input_lin <-aggregate_by_cell_bin(input_cds, "cell_subtype")

}
