% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{upstream_partner_gene}
\alias{upstream_partner_gene}
\alias{upstream_partner_gene,Fusion-method}
\alias{upstream_partner_gene<-}
\alias{upstream_partner_gene<-,Fusion-method}
\title{Get the upstream fusion partner gene}
\usage{
upstream_partner_gene(x)

\S4method{upstream_partner_gene}{Fusion}(x)

upstream_partner_gene(object) <- value

\S4method{upstream_partner_gene}{Fusion}(object) <- value
}
\arguments{
\item{x}{The Fusion object you wish to retrieve the upstream PartnerGene
object for.}

\item{object}{The Fusion object you wish to set a new upstream PartnerGene
object for.}

\item{value}{The new PartnerGene object.}
}
\value{
The upstream PartnerGene object.
}
\description{
This getter retrieves the upstream PartnerGene object.

This sets the upstream PartnerGene object of a Fusion object
}
\examples{
# Load data
defuseData <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuseData, "hg19", 1)
fusion <- fusions[[1]]
# Get the upstream fusion partner gene
upstream_partner_gene(fusion)

# Load data
defuseData <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuseData, "hg19", 1)
fusion <- fusions[[1]]
# Set the upstream PartnerGene object to be the same as the downstream
# PartnerGene object
upstream_partner_gene(fusion) <- downstream_partner_gene(fusion)

}
