% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fusion_by.R
\name{get_fusion_by_chromosome}
\alias{get_fusion_by_chromosome}
\title{Find fusions that involves genes in the given chromosome.}
\usage{
get_fusion_by_chromosome(fusion_list, chr)
}
\arguments{
\item{fusion_list}{A list of Fusion objects.}

\item{chr}{The chromosome name we're looking for fusions in.}
}
\value{
A list of Fusion objects.
}
\description{
Helper function to retrieve the Fusion objects that involves genes in the
given chromosome name.
}
\examples{
defuse833ke <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 1)
length(get_fusion_by_chromosome(fusions, "chr1"))
# [1] 1

}
