% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{get_ensembl_ids}
\alias{get_ensembl_ids}
\title{Get ensembl ids for a fusion object}
\usage{
get_ensembl_ids(fusion)
}
\arguments{
\item{fusion}{The Fusion object we want to get ensembl ids for.}
}
\value{
The Fusion object with Ensembl ids set.
}
\description{
This function will get the ensembl ids from the org.Hs.eg.db/org.Mm.eg.db
package given the gene names of the fusion event.
}
\examples{
# Import the filtered defuse results
defuse833keFiltered <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833keFiltered, "hg19", 1)
# Get a specific fusion
fusion <- get_fusion_by_id(fusions, 5267)
# See the ensembl ids:
partner_gene_ensembl_id(upstream_partner_gene(fusion))
# [1] "ENSG00000180198"
partner_gene_ensembl_id(downstream_partner_gene(fusion))
# [1] "ENSG00000162639"
# Reset the fusion objects ensembl ids
partner_gene_ensembl_id(upstream_partner_gene(fusion)) <- ""
partner_gene_ensembl_id(downstream_partner_gene(fusion))  <- ""
# Get the ensembl ids
fusion <- get_ensembl_ids(fusion)
# See that we now have the same ensembl ids again:
partner_gene_ensembl_id(upstream_partner_gene(fusion))
# [1] "ENSG00000180198"
partner_gene_ensembl_id(downstream_partner_gene(fusion))
# [1] "ENSG00000162639"

}
