% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sl_ratio.R
\name{plot_sl_ratio}
\alias{plot_sl_ratio}
\title{Plot Short/Long-fragment Ratio}
\usage{
plot_sl_ratio(fragment_profile, ylim = c(0, 0.4), genome = "hg19")
}
\arguments{
\item{fragment_profile}{list}

\item{ylim}{plot y-axis limit}

\item{genome}{Character; version of reference genome (default hg19)}
}
\value{
plot
}
\description{
Plot Short/Long-fragment Ratio
}
\examples{
example_file <-  system.file("extdata","example_patientcfDNA_SampleBam.RDS",package = "cfdnakit")
sample_bambin <- readRDS(example_file)
sample_profile <- get_fragment_profile(sample_bambin,sample_id = "Patient1")
plot_sl_ratio(fragment_profile = sample_profile)

### change plot y-axis
plot_sl_ratio(fragment_profile = sample_profile,  ylim=c(0.1,0.5))

### change reference genome
plot_sl_ratio(fragment_profile = sample_profile,  genome="hg38")
}
