% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{wsaPreProcessing}
\alias{wsaPreProcessing}
\title{Data preprocessing for wound scratch assay (WSA).}
\usage{
wsaPreProcessing(
  object,
  PixelSize = 1.24,
  TimeInterval = 10,
  FrameN = NULL,
  imageH = 1500,
  woundH = 600,
  upperE = 400,
  lowerE = 1000,
  mar = 75,
  clearW = TRUE,
  ExpName = NULL
)
}
\arguments{
\item{object}{\code{CellMig} class object.}

\item{PixelSize}{A numeric value of the physical size of a pixel.}

\item{TimeInterval}{A numeric value of the time elapsed between
successive frames in the time-lapse stack.}

\item{FrameN}{A numeric value of the number of frames. Default
is NULL}

\item{imageH}{A numeric value of the image height.}

\item{woundH}{A numeric value of the image height.}

\item{upperE}{A numeric value of the upper edge of the wound.}

\item{lowerE}{A numeric value of the lower edge of the wound.}

\item{mar}{A numeric value of the margin to be used to narrow
the clearing zone inside the zone.}

\item{clearW}{A logical vector that allows removing the cells
within the wound. Default is TRUE.}

\item{ExpName}{string, name of the experiment. Can be NULL}
}
\value{
An CellMig class object with filtered, annotated
and preprocessed data.
}
\description{
This function allows filtering of cells and
preprocessing
of the trajectory data from wound scratch assay (WSA) experiments.
}
\examples{
WSADataset <- get(data(WSADataset))
wasDF=WSADataset[seq(1,30,by=1),]
wsaTD <- CellMig(wasDF)
wsaTD <- wsaPreProcessing(wsaTD,FrameN=20)

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
