% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{visualizeCellTracks}
\alias{visualizeCellTracks}
\title{Visualize Cell Tracks originating at an Image Stack}
\usage{
visualizeCellTracks(
  tc_obj,
  stack = 1,
  pnt.cex = 1.2,
  lwd = 1.6,
  col = "red2",
  col.untracked = "gray45",
  main = NULL
)
}
\arguments{
\item{tc_obj}{a trackedCells object}

\item{stack}{index of the stack}

\item{pnt.cex}{cex of the point drawn around each cell}

\item{lwd}{width of the lines visualizing cell tracks}

\item{col}{color of the points and the tracks, e.g.: "red2"}

\item{col.untracked}{color of the points that were not tracked
further, e.g.: "gray45"}

\item{main}{string used as plot title, can be NULL}
}
\value{
None
}
\description{
Visualize Cell Tracks that originated at an Image Stack of interest
}
\examples{
x <- get(data(TrackCellsDataset))
visualizeCellTracks(tc_obj = x, stack = 2)


}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
\url{https://www.mathworks.com/matlabcentral/fileexchange/60349-fasttracks}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
