% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitModule.R
\name{splitModule}
\alias{splitModule}
\alias{splitModule,SingleCellExperiment-method}
\title{Split celda feature module}
\usage{
splitModule(
  x,
  module,
  useAssay = "counts",
  altExpName = "featureSubset",
  n = 2,
  seed = 12345
)

\S4method{splitModule}{SingleCellExperiment}(
  x,
  module,
  useAssay = "counts",
  altExpName = "featureSubset",
  n = 2,
  seed = 12345
)
}
\arguments{
\item{x}{A \linkS4class{SingleCellExperiment} object
with the matrix located in the assay slot under \code{useAssay}.
Rows represent features and columns represent cells.}

\item{module}{Integer. The module to be split.}

\item{useAssay}{A string specifying which \link{assay}
slot to use for \code{x}. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default \code{"featureSubset"}.}

\item{n}{Integer. How many modules should \code{module} be split into.
Default \code{2}.}

\item{seed}{Integer. Passed to \link[withr]{with_seed}. For reproducibility,
a default value of 12345 is used. If NULL, no calls to
\link[withr]{with_seed} are made.}
}
\value{
A updated \linkS4class{SingleCellExperiment} object with new
 feature modules stored in column \code{celda_feature_module} in
 \code{\link{rowData}(x)}.
}
\description{
Manually select a celda feature module to split into 2 or
 more modules. Useful for splitting up modules that show divergent
 expression of features in multiple cell clusters.
}
\examples{
data(sceCeldaCG)
# Split module 5 into 2 new modules.
sce <- splitModule(sceCeldaCG, module = 5)
}
