% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_decontx.R
\name{plotDecontXContamination}
\alias{plotDecontXContamination}
\title{Plots contamination on UMAP coordinates}
\usage{
plotDecontXContamination(
  x,
  batch = NULL,
  colorScale = c("blue", "green", "yellow", "orange", "red"),
  size = 1
)
}
\arguments{
\item{x}{Either a \linkS4class{SingleCellExperiment} with \code{decontX}
results stored in \code{metadata(x)$decontX} or the result from running
decontX on a count matrix.}

\item{batch}{Character. Batch of cells to plot. If \code{NULL}, then
the first batch in the list will be selected. Default \code{NULL}.}

\item{colorScale}{Character vector. Contains the color spectrum to be passed
to \code{scale_colour_gradientn} from package 'ggplot2'. Default
c("blue","green","yellow","orange","red").}

\item{size}{Numeric. Size of points in the scatterplot. Default 1.}
}
\value{
Returns a \code{ggplot} object.
}
\description{
A scatter plot of the UMAP dimensions generated by DecontX with
cells colored by the estimated percentation of contamation.
}
\seealso{
See \code{\link{decontX}} for a full example of how to estimate
and plot contamination.
}
\author{
Shiyi Yang, Joshua Campbell
}
