% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celda_functions.R
\name{normalizeCounts}
\alias{normalizeCounts}
\title{Normalization of count data}
\usage{
normalizeCounts(
  counts,
  normalize = c("proportion", "cpm", "median", "mean"),
  scaleFactor = NULL,
  transformationFun = NULL,
  scaleFun = NULL,
  pseudocountNormalize = 0,
  pseudocountTransform = 0
)
}
\arguments{
\item{counts}{Integer, Numeric or Sparse matrix. Rows represent features
and columns represent cells.}

\item{normalize}{Character.
Divides counts by the library sizes for each cell. One of 'proportion',
'cpm', 'median', or 'mean'. 'proportion' uses the total counts for each
cell as the library size. 'cpm' divides the library size of each cell by
one million to produce counts per million. 'median' divides the library
size of each cell by the median library size across all cells. 'mean'
divides the library size of each cell by the mean library size across all
cells.}

\item{scaleFactor}{Numeric. Sets the scale factor for cell-level
normalization. This scale factor is multiplied to each cell after the
library size of each cell had been adjusted in \code{normalize}. Default
\code{NULL} which means no scale factor is applied.}

\item{transformationFun}{Function. Applys a transformation such as
\link{sqrt}, \link{log}, \link{log2}, \link{log10}, or \link{log1p}.
If NULL, no transformation will be applied. Occurs after normalization.
Default NULL.}

\item{scaleFun}{Function. Scales the rows of the normalized and transformed
count matrix. For example, 'scale' can be used to z-score normalize the
rows. Default NULL.}

\item{pseudocountNormalize}{Numeric. Add a pseudocount to counts before
normalization. Default 0.}

\item{pseudocountTransform}{Numeric. Add a pseudocount to normalized counts
before applying the transformation function. Adding a pseudocount
can be useful before applying a log transformation. Default  0.}
}
\value{
Numeric Matrix. A normalized matrix.
}
\description{
Performs normalization, transformation, and/or scaling of a
 counts matrix
}
\examples{
data(celdaCGSim)
normalizedCounts <- normalizeCounts(celdaCGSim$counts, "proportion",
  pseudocountNormalize = 1)
}
