% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celda_G.R
\name{celda_G}
\alias{celda_G}
\alias{celda_G,SingleCellExperiment-method}
\alias{celda_G,ANY-method}
\title{Feature clustering with Celda}
\usage{
celda_G(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  L,
  beta = 1,
  delta = 1,
  gamma = 1,
  stopIter = 10,
  maxIter = 200,
  splitOnIter = 10,
  splitOnLast = TRUE,
  seed = 12345,
  nchains = 3,
  yInitialize = c("split", "random", "predefined"),
  countChecksum = NULL,
  yInit = NULL,
  logfile = NULL,
  verbose = TRUE
)

\S4method{celda_G}{SingleCellExperiment}(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  L,
  beta = 1,
  delta = 1,
  gamma = 1,
  stopIter = 10,
  maxIter = 200,
  splitOnIter = 10,
  splitOnLast = TRUE,
  seed = 12345,
  nchains = 3,
  yInitialize = c("split", "random", "predefined"),
  countChecksum = NULL,
  yInit = NULL,
  logfile = NULL,
  verbose = TRUE
)

\S4method{celda_G}{ANY}(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  L,
  beta = 1,
  delta = 1,
  gamma = 1,
  stopIter = 10,
  maxIter = 200,
  splitOnIter = 10,
  splitOnLast = TRUE,
  seed = 12345,
  nchains = 3,
  yInitialize = c("split", "random", "predefined"),
  countChecksum = NULL,
  yInit = NULL,
  logfile = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{A \linkS4class{SingleCellExperiment}
with the matrix located in the assay slot under \code{useAssay}.
Rows represent features and columns represent cells. Alternatively,
any matrix-like object that can be coerced to a sparse matrix of class
"dgCMatrix" can be directly used as input. The matrix will automatically be
converted to a \linkS4class{SingleCellExperiment} object.}

\item{useAssay}{A string specifying the name of the
\link{assay} slot to use. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{L}{Integer. Number of feature modules.}

\item{beta}{Numeric. Concentration parameter for Phi. Adds a pseudocount to
each feature module in each cell. Default 1.}

\item{delta}{Numeric. Concentration parameter for Psi. Adds a pseudocount to
each feature in each module. Default 1.}

\item{gamma}{Numeric. Concentration parameter for Eta. Adds a pseudocount to
the number of features in each module. Default 1.}

\item{stopIter}{Integer. Number of iterations without improvement in the
log likelihood to stop inference. Default 10.}

\item{maxIter}{Integer. Maximum number of iterations of Gibbs sampling to
perform. Default 200.}

\item{splitOnIter}{Integer. On every `splitOnIter` iteration, a heuristic
will be applied to determine if a feature module should be reassigned and
another feature module should be split into two clusters. To disable
splitting, set to -1. Default 10.}

\item{splitOnLast}{Integer. After `stopIter` iterations have been
performed without improvement, a heuristic will be applied to determine if
a cell population should be reassigned and another cell population should be
split into two clusters. If a split occurs, then `stopIter` will be reset.
Default TRUE.}

\item{seed}{Integer. Passed to \link[withr]{with_seed}. For reproducibility,
a default value of 12345 is used. If NULL, no calls to
\link[withr]{with_seed} are made.}

\item{nchains}{Integer. Number of random cluster initializations. Default 3.}

\item{yInitialize}{Chararacter. One of 'random', 'split', or 'predefined'.
With 'random', features are randomly assigned to a modules. With 'split',
features will be split into sqrt(L) modules and then each module will be
subsequently split into another sqrt(L) modules. With 'predefined', values
in `yInit` will be used to initialize `y`. Default 'split'.}

\item{countChecksum}{Character. An MD5 checksum for the `counts` matrix.
Default NULL.}

\item{yInit}{Integer vector. Sets initial starting values of y.
`yInit` can only be used when `yInitialize = 'predefined'`. Default NULL.}

\item{logfile}{Character. Messages will be redirected to a file named
\code{logfile}. If NULL, messages will be printed to stdout. Default NULL.}

\item{verbose}{Logical. Whether to print log messages. Default TRUE.}
}
\value{
A \linkS4class{SingleCellExperiment} object. Function
 parameter settings are stored in the \link{metadata}
 \code{"celda_parameters"} slot. Column \code{celda_feature_module} in
 \link{rowData} contains feature modules.
}
\description{
Clusters the rows of a count matrix containing single-cell data
 into L modules. The
 \code{useAssay} \link{assay} slot in
 \code{altExpName} \link{altExp} slot will be used if
 it exists. Otherwise, the \code{useAssay}
 \link{assay} slot in \code{x} will be used if
 \code{x} is a \linkS4class{SingleCellExperiment} object.
}
\examples{
data(celdaGSim)
sce <- celda_G(celdaGSim$counts, L = celdaGSim$L, nchains = 1)
}
\seealso{
\link{celda_C} for cell clustering and \link{celda_CG} for
 simultaneous clustering of features and cells. \link{celdaGridSearch} can
 be used to run multiple values of L and multiple chains in parallel.
}
