% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celda_CG.R
\name{celda_CG}
\alias{celda_CG}
\alias{celda_CG,SingleCellExperiment-method}
\alias{celda_CG,ANY-method}
\title{Cell and feature clustering with Celda}
\usage{
celda_CG(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  sampleLabel = NULL,
  K,
  L,
  alpha = 1,
  beta = 1,
  delta = 1,
  gamma = 1,
  algorithm = c("EM", "Gibbs"),
  stopIter = 10,
  maxIter = 200,
  splitOnIter = 10,
  splitOnLast = TRUE,
  seed = 12345,
  nchains = 3,
  zInitialize = c("split", "random", "predefined"),
  yInitialize = c("split", "random", "predefined"),
  countChecksum = NULL,
  zInit = NULL,
  yInit = NULL,
  logfile = NULL,
  verbose = TRUE
)

\S4method{celda_CG}{SingleCellExperiment}(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  sampleLabel = NULL,
  K,
  L,
  alpha = 1,
  beta = 1,
  delta = 1,
  gamma = 1,
  algorithm = c("EM", "Gibbs"),
  stopIter = 10,
  maxIter = 200,
  splitOnIter = 10,
  splitOnLast = TRUE,
  seed = 12345,
  nchains = 3,
  zInitialize = c("split", "random", "predefined"),
  yInitialize = c("split", "random", "predefined"),
  countChecksum = NULL,
  zInit = NULL,
  yInit = NULL,
  logfile = NULL,
  verbose = TRUE
)

\S4method{celda_CG}{ANY}(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  sampleLabel = NULL,
  K,
  L,
  alpha = 1,
  beta = 1,
  delta = 1,
  gamma = 1,
  algorithm = c("EM", "Gibbs"),
  stopIter = 10,
  maxIter = 200,
  splitOnIter = 10,
  splitOnLast = TRUE,
  seed = 12345,
  nchains = 3,
  zInitialize = c("split", "random", "predefined"),
  yInitialize = c("split", "random", "predefined"),
  countChecksum = NULL,
  zInit = NULL,
  yInit = NULL,
  logfile = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{A \linkS4class{SingleCellExperiment}
with the matrix located in the assay slot under \code{useAssay}.
Rows represent features and columns represent cells. Alternatively,
any matrix-like object that can be coerced to a sparse matrix of class
"dgCMatrix" can be directly used as input. The matrix will automatically be
converted to a \linkS4class{SingleCellExperiment} object.}

\item{useAssay}{A string specifying the name of the
\link{assay} slot to use. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{sampleLabel}{Vector or factor. Denotes the sample label for each cell
(column) in the count matrix.}

\item{K}{Integer. Number of cell populations.}

\item{L}{Integer. Number of feature modules.}

\item{alpha}{Numeric. Concentration parameter for Theta. Adds a pseudocount
to each cell population in each sample. Default 1.}

\item{beta}{Numeric. Concentration parameter for Phi. Adds a pseudocount to
each feature module in each cell population. Default 1.}

\item{delta}{Numeric. Concentration parameter for Psi. Adds a pseudocount to
each feature in each module. Default 1.}

\item{gamma}{Numeric. Concentration parameter for Eta. Adds a pseudocount to
the number of features in each module. Default 1.}

\item{algorithm}{String. Algorithm to use for clustering cell subpopulations.
One of 'EM' or 'Gibbs'. The EM algorithm for cell clustering is faster,
especially for larger numbers of cells. However, more chains may be required
to ensure a good solution is found. Default 'EM'.}

\item{stopIter}{Integer. Number of iterations without improvement in the log
likelihood to stop inference. Default 10.}

\item{maxIter}{Integer. Maximum number of iterations of Gibbs sampling to
perform. Default 200.}

\item{splitOnIter}{Integer. On every \code{splitOnIter} iteration,
a heuristic
will be applied to determine if a cell population or feature module should
be reassigned and another cell population or feature module should be split
into two clusters. To disable splitting, set to -1. Default 10.}

\item{splitOnLast}{Integer. After \code{stopIter} iterations have been
performed without improvement, a heuristic will be applied to determine if
a cell population or feature module should be reassigned and another cell
population or feature module should be split into two clusters. If a split
occurs, then 'stopIter' will be reset. Default TRUE.}

\item{seed}{Integer. Passed to \link[withr]{with_seed}. For reproducibility,
a default value of 12345 is used. If NULL, no calls to
\link[withr]{with_seed} are made.}

\item{nchains}{Integer. Number of random cluster initializations. Default 3.}

\item{zInitialize}{Chararacter. One of 'random', 'split', or 'predefined'.
With 'random', cells are randomly assigned to a populations. With 'split',
cells will be split into sqrt(K) populations and then each population will
be subsequently split into another sqrt(K) populations. With 'predefined',
values in \code{zInit} will be used to initialize \code{z}. Default 'split'.}

\item{yInitialize}{Character. One of 'random', 'split', or 'predefined'.
With 'random', features are randomly assigned to a modules. With 'split',
features will be split into sqrt(L) modules and then each module will be
subsequently split into another sqrt(L) modules. With 'predefined', values
in \code{yInit} will be used to initialize \code{y}. Default 'split'.}

\item{countChecksum}{Character. An MD5 checksum for the counts matrix.
Default NULL.}

\item{zInit}{Integer vector. Sets initial starting values of z. 'zInit'
is only used when `zInitialize = 'predfined'`. Default NULL.}

\item{yInit}{Integer vector. Sets initial starting values of y.
'yInit' is only be used when `yInitialize = "predefined"`. Default NULL.}

\item{logfile}{Character. Messages will be redirected to a file named
`logfile`. If NULL, messages will be printed to stdout.  Default NULL.}

\item{verbose}{Logical. Whether to print log messages. Default TRUE.}
}
\value{
A \linkS4class{SingleCellExperiment} object. Function
 parameter settings are stored in \link{metadata}
 \code{"celda_parameters"} in \link{altExp} slot.
 In \link{altExp} slot,
 columns \code{celda_sample_label} and \code{celda_cell_cluster} in
 \link{colData} contain sample labels and celda cell
 population clusters. Column \code{celda_feature_module} in
 \link{rowData} contains feature modules.
}
\description{
Clusters the rows and columns of a count matrix containing
 single-cell data into L modules and K subpopulations, respectively. The
 \code{useAssay} \link{assay} slot in
 \code{altExpName} \link{altExp} slot will be used if
 it exists. Otherwise, the \code{useAssay}
 \link{assay} slot in \code{x} will be used if
 \code{x} is a \linkS4class{SingleCellExperiment} object.
}
\examples{
data(celdaCGSim)
sce <- celda_CG(celdaCGSim$counts,
    K = celdaCGSim$K,
    L = celdaCGSim$L,
    sampleLabel = celdaCGSim$sampleLabel,
    nchains = 1)
}
\seealso{
\link{celda_G} for feature clustering and \link{celda_C} for
 clustering cells. \link{celdaGridSearch} can be used to run multiple
 values of K/L and multiple chains in parallel.
}
