% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celda_C.R
\name{celda_C}
\alias{celda_C}
\alias{celda_C,SingleCellExperiment-method}
\alias{celda_C,ANY-method}
\title{Cell clustering with Celda}
\usage{
celda_C(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  sampleLabel = NULL,
  K,
  alpha = 1,
  beta = 1,
  algorithm = c("EM", "Gibbs"),
  stopIter = 10,
  maxIter = 200,
  splitOnIter = 10,
  splitOnLast = TRUE,
  seed = 12345,
  nchains = 3,
  zInitialize = c("split", "random", "predefined"),
  countChecksum = NULL,
  zInit = NULL,
  logfile = NULL,
  verbose = TRUE
)

\S4method{celda_C}{SingleCellExperiment}(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  sampleLabel = NULL,
  K,
  alpha = 1,
  beta = 1,
  algorithm = c("EM", "Gibbs"),
  stopIter = 10,
  maxIter = 200,
  splitOnIter = 10,
  splitOnLast = TRUE,
  seed = 12345,
  nchains = 3,
  zInitialize = c("split", "random", "predefined"),
  countChecksum = NULL,
  zInit = NULL,
  logfile = NULL,
  verbose = TRUE
)

\S4method{celda_C}{ANY}(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  sampleLabel = NULL,
  K,
  alpha = 1,
  beta = 1,
  algorithm = c("EM", "Gibbs"),
  stopIter = 10,
  maxIter = 200,
  splitOnIter = 10,
  splitOnLast = TRUE,
  seed = 12345,
  nchains = 3,
  zInitialize = c("split", "random", "predefined"),
  countChecksum = NULL,
  zInit = NULL,
  logfile = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{A \linkS4class{SingleCellExperiment}
with the matrix located in the assay slot under \code{useAssay}.
Rows represent features and columns represent cells. Alternatively,
any matrix-like object that can be coerced to a sparse matrix of class
"dgCMatrix" can be directly used as input. The matrix will automatically be
converted to a \linkS4class{SingleCellExperiment} object.}

\item{useAssay}{A string specifying the name of the
\link{assay} slot to use. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{sampleLabel}{Vector or factor. Denotes the sample label for each cell
(column) in the count matrix.}

\item{K}{Integer. Number of cell populations.}

\item{alpha}{Numeric. Concentration parameter for Theta. Adds a pseudocount
to each cell population in each sample. Default 1.}

\item{beta}{Numeric. Concentration parameter for Phi. Adds a pseudocount to
each feature in each cell population. Default 1.}

\item{algorithm}{String. Algorithm to use for clustering cell subpopulations.
One of 'EM' or 'Gibbs'. The EM algorithm is faster, especially for larger
numbers of cells. However, more chains may be required to ensure a good
solution is found. If 'EM' is selected, then 'stopIter' will be
automatically set to 1. Default 'EM'.}

\item{stopIter}{Integer. Number of iterations without improvement in the
log likelihood to stop inference. Default 10.}

\item{maxIter}{Integer. Maximum number of iterations of Gibbs sampling or
EM to perform. Default 200.}

\item{splitOnIter}{Integer. On every `splitOnIter` iteration, a heuristic
will be applied to determine if a cell population should be reassigned and
another cell population should be split into two clusters. To disable
splitting, set to -1. Default 10.}

\item{splitOnLast}{Integer. After `stopIter` iterations have been
performed without improvement, a heuristic will be applied to determine if
a cell population should be reassigned and another cell population should be
split into two clusters. If a split occurs, then `stopIter` will be reset.
Default TRUE.}

\item{seed}{Integer. Passed to \link[withr]{with_seed}. For reproducibility,
a default value of 12345 is used. If NULL, no calls to
\link[withr]{with_seed} are made.}

\item{nchains}{Integer. Number of random cluster initializations. Default 3.}

\item{zInitialize}{Character. One of 'random', 'split', or 'predefined'.
With 'random', cells are randomly assigned to a populations. With 'split',
cells will be split into sqrt(K) populations and then each population will
be subsequently split into another sqrt(K) populations. With 'predefined',
values in `zInit` will be used to initialize `z`. Default 'split'.}

\item{countChecksum}{Character. An MD5 checksum for the `counts` matrix.
Default NULL.}

\item{zInit}{Integer vector. Sets initial starting values of z. 'zInit'
is only used when `zInitialize = 'predfined'`. Default NULL.}

\item{logfile}{Character. Messages will be redirected to a file named
`logfile`. If NULL, messages will be printed to stdout.  Default NULL.}

\item{verbose}{Logical. Whether to print log messages. Default TRUE.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object. Function
 parameter settings are stored in the \link{metadata}
 \code{"celda_parameters"} slot.
 Columns \code{celda_sample_label} and \code{celda_cell_cluster} in
 \link{colData} contain sample labels and celda cell
 population clusters.
}
\description{
Clusters the columns of a count matrix containing single-cell
 data into K subpopulations. The
 \code{useAssay} \link{assay} slot in
 \code{altExpName} \link{altExp} slot will be used if
 it exists. Otherwise, the \code{useAssay}
 \link{assay} slot in \code{x} will be used if
 \code{x} is a \linkS4class{SingleCellExperiment} object.
}
\examples{
data(celdaCSim)
sce <- celda_C(celdaCSim$counts,
    K = celdaCSim$K,
    sampleLabel = celdaCSim$sampleLabel,
    nchains = 1)
}
\seealso{
\link{celda_G} for feature clustering and \link{celda_CG} for
 simultaneous clustering of features and cells. \link{celdaGridSearch} can
 be used to run multiple values of K and multiple chains in parallel.
}
