% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celdatSNE.R
\name{celdaTsne}
\alias{celdaTsne}
\alias{celdaTsne,SingleCellExperiment-method}
\title{t-Distributed Stochastic Neighbor Embedding (t-SNE) dimension
 reduction for celda \code{sce} object}
\usage{
celdaTsne(
  sce,
  useAssay = "counts",
  altExpName = "featureSubset",
  maxCells = NULL,
  minClusterSize = 100,
  initialDims = 20,
  modules = NULL,
  perplexity = 20,
  maxIter = 2500,
  normalize = "proportion",
  scaleFactor = NULL,
  transformationFun = sqrt,
  seed = 12345
)

\S4method{celdaTsne}{SingleCellExperiment}(
  sce,
  useAssay = "counts",
  altExpName = "featureSubset",
  maxCells = NULL,
  minClusterSize = 100,
  initialDims = 20,
  modules = NULL,
  perplexity = 20,
  maxIter = 2500,
  normalize = "proportion",
  scaleFactor = NULL,
  transformationFun = sqrt,
  seed = 12345
)
}
\arguments{
\item{sce}{A \linkS4class{SingleCellExperiment} object
returned by \link{celda_C}, \link{celda_G}, or \link{celda_CG}.}

\item{useAssay}{A string specifying which \link{assay}
slot to use. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{maxCells}{Integer. Maximum number of cells to plot. Cells will be
randomly subsampled if \code{ncol(counts) > maxCells}. Larger numbers of
cells requires more memory. If \code{NULL}, no subsampling will be
performed. Default \code{NULL}.}

\item{minClusterSize}{Integer. Do not subsample cell clusters below this
threshold. Default 100.}

\item{initialDims}{Integer. PCA will be used to reduce the dimensionality
of the dataset. The top 'initialDims' principal components will be used
for tSNE. Default 20.}

\item{modules}{Integer vector. Determines which feature modules to use for
tSNE. If \code{NULL}, all modules will be used. Default \code{NULL}.}

\item{perplexity}{Numeric. Perplexity parameter for tSNE. Default 20.}

\item{maxIter}{Integer. Maximum number of iterations in tSNE generation.
Default 2500.}

\item{normalize}{Character. Passed to \link{normalizeCounts} in
normalization step. Divides counts by the library sizes for each
cell. One of 'proportion', 'cpm', 'median', or 'mean'. 'proportion' uses
the total counts for each cell as the library size. 'cpm' divides the
library size of each cell by one million to produce counts per million.
'median' divides the library size of each cell by the median library size
across all cells. 'mean' divides the library size of each cell by the mean
library size across all cells.}

\item{scaleFactor}{Numeric. Sets the scale factor for cell-level
normalization. This scale factor is multiplied to each cell after the
library size of each cell had been adjusted in \code{normalize}. Default
\code{NULL} which means no scale factor is applied.}

\item{transformationFun}{Function. Applys a transformation such as 'sqrt',
'log', 'log2', 'log10', or 'log1p'. If \code{NULL}, no transformation will
be applied. Occurs after applying normalization and scale factor. Default
\code{NULL}.}

\item{seed}{Integer. Passed to \link[withr]{with_seed}. For reproducibility,
a default value of 12345 is used. If NULL, no calls to
\link[withr]{with_seed} are made.}
}
\value{
\code{sce} with t-SNE coordinates
 (columns "celda_tSNE1" & "celda_tSNE2") added to
 \code{\link{reducedDim}(sce, "celda_tSNE")}.
}
\description{
Embeds cells in two dimensions using \link[Rtsne]{Rtsne} based
 on a celda model. For celda_C \code{sce} objects, PCA on the normalized
 counts is used to reduce the number of features before applying t-SNE. For
 celda_CG and celda_G \code{sce} objects, tSNE is run on module
 probabilities to reduce the number of features instead of using PCA.
 Module probabilities are square-root transformed before applying tSNE.
}
\examples{
data(sceCeldaCG)
tsneRes <- celdaTsne(sceCeldaCG)
}
