% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikelihood.R
\name{bestLogLikelihood}
\alias{bestLogLikelihood}
\alias{bestLogLikelihood,SingleCellExperiment-method}
\alias{bestLogLikelihood,celdaModel-method}
\title{Get the log-likelihood}
\usage{
bestLogLikelihood(x, altExpName = "featureSubset")

\S4method{bestLogLikelihood}{SingleCellExperiment}(x, altExpName = "featureSubset")

\S4method{bestLogLikelihood}{celdaModel}(x)
}
\arguments{
\item{x}{A \linkS4class{SingleCellExperiment} object
returned by \link{celda_C}, \link{celda_G}, or \link{celda_CG}, or a celda
model object.}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}
}
\value{
Numeric. The log-likelihood at the final step of Gibbs sampling used
 to generate the model.
}
\description{
Retrieves the final log-likelihood from all iterations of Gibbs
 sampling used to generate a celdaModel.
}
\examples{
data(sceCeldaCG)
bestLogLikelihood(sceCeldaCG)
data(celdaCGMod)
bestLogLikelihood(celdaCGMod)
}
