% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{rename_tips}
\alias{rename_tips}
\title{Rename tips of trees with cell types}
\usage{
rename_tips(tree, rank, tip.labels)
}
\arguments{
\item{tree}{List containing tree}

\item{rank}{Rank value of which tip names are to be replaced}

\item{tip.labels}{Vector of new names for tips}
}
\value{
List containing tree with updated tip labels
}
\description{
Rename tips of trees with cell types
}
\examples{
set.seed(1)
x <- simulate_whx(nrow=50,ncol=100,rank=5)
s <- scNMFSet(x$x)
s <- vb_factorize(s,ranks=seq(2,8),nrun=5)
tree <- build_tree(s,rmax=5)
tree <- rename_tips(tree,rank=5,tip.labels=letters[seq_len(5)])
tree 
}
