% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{check_input_dates}
\alias{check_input_dates}
\title{Check the input of dates}
\usage{
check_input_dates(diagnosisDate, startDate = NULL, endDate = NULL)
}
\arguments{
\item{diagnosisDate}{date of first diagnosis}

\item{startDate}{start date of timeline event}

\item{endDate}{end date of timeline event}
}
\value{
Returns a number indicating the warning
}
\description{
Check the input of dates
}
\examples{
cbpManager:::check_input_dates(
    diagnosisDate = "2020-01-01", 
    startDate = "2020-02-01", 
    endDate = "2020-03-01"
) #returns 0
cbpManager:::check_input_dates(
    diagnosisDate = "2020-01-01", 
    startDate = "2019-02-01"
) #returns 2
cbpManager:::check_input_dates(
    diagnosisDate = "2020-01-01", 
    endDate = "2019-02-01"
) #returns 2
cbpManager:::check_input_dates(
    diagnosisDate = "2020-01-01", 
    startDate = "2020-03-01", 
    endDate = "2020-02-01"
) #returns 1

}
