% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich-plots.R
\name{sumovmod}
\alias{sumovmod}
\alias{sumovPlotUI}
\alias{sumovPlotServer}
\title{Summary overview plot module}
\usage{
sumovPlotUI(id, panel, type = "")

sumovPlotServer(id, obj, config, type = "")
}
\arguments{
\item{id}{Module id}

\item{panel}{string, can be 'sidebar' or 'main'}

\item{type}{string, if 'comp' then show the comparison view}

\item{obj}{reactiveValues object containing GeneTonic object}

\item{config}{reactive list with config settings}
}
\value{
UI returns tagList with plot UI
server invisibly returns NULL (used for side effects)
}
\description{
UI & module to generate summary overview plots.
}
\examples{
library(shiny)

# get enrichResult object
data(eres_dex, package='carnation')

# convert to GeneTonic object
gt <- GeneTonic::shake_enrichResult(eres_dex)

obj <- reactive({
  list(l_gs = gt$l_gs,
       anno_df = gt$anno_df,
       label = 'comp1')
})

config <- reactiveVal(get_config())

# run simple shiny app with plot
if(interactive()){
  shinyApp(
    ui = fluidPage(
           sidebarPanel(sumovPlotUI('p', 'sidebar')),
           mainPanel(sumovPlotUI('p', 'main'))
         ),
    server = function(input, output, session){
               sumovPlotServer('p', obj, config)
             }
  )
}

}
