% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_object.R
\name{savemod}
\alias{savemod}
\alias{saveUI}
\alias{saveServer}
\title{Save object module UI}
\usage{
saveUI(id)

saveServer(id, original, current, coldata, pattern, username, config)
}
\arguments{
\item{id}{Module id}

\item{original}{original carnation object}

\item{current}{current carnation object}

\item{coldata}{reactiveValues object containing object metadata}

\item{pattern}{regex pattern for finding carnation data}

\item{username}{user name}

\item{config}{reactive list with config settings}
}
\value{
UI returns actionButton
Server returns reactive with trigger to refresh the app
}
\description{
Module UI & server to save carnation object.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)
library(DESeq2)

# default username
username <- reactive({ NULL })

# internal carnation config
config <- reactiveVal(get_config())

# regex to find carnation files
pattern <- reactive({ config()$server$pattern })

# get example object
obj <- make_example_carnation_object()

# make reactive with obj & path
original <- reactiveValues( obj = obj, path = "/path/to/carnation/obj.rds" )

# extract metadata
coldata <- reactive({ lapply(obj$dds, colData) })

# edit metadata
coldata_edit <- lapply(coldata, function(x){
                  x$type <- 'new'; x
                })

# add to object
edit_obj <- obj
for(name in names(edit_obj$dds)){
  colData(edit_obj$dds[[ name ]]) <- coldata_edit[[ name ]]
}

# run simple shiny app with plot
shinyApp(
  ui = fluidPage(
         saveUI('p')
       ),
  server = function(input, output, session){
             save_event <- saveServer('save_object',
                                      original=original,
                                      current=reactive({ edit_obj }),
                                      coldata=coldata,
                                      pattern=pattern(),
                                      username=username,
                                      config)
           }
)
\dontshow{\}) # examplesIf}
}
