% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{save_access_yaml}
\alias{save_access_yaml}
\title{Save access yaml to file}
\usage{
save_access_yaml(lst)
}
\arguments{
\item{lst}{list of data frames with user_groups and
data_areas}
}
\value{
save access settings to yaml file
}
\description{
This function saves access details (user groups
and data areas) to the designated access yaml file.
}
\examples{
# save access details to file
home <- Sys.getenv('HOME')

# create carnation data area if it doesn't exist
carnation_home <- file.path(home, 'carnation/data')
if(!dir.exists(carnation_home)) dir.create(carnation_home)

create_access_yaml(user = 'admin',
                   user_group = 'admin',
                   data_area = carnation_home)

# read access yaml
lst <- read_access_yaml()

# add new user
lst$user_group$admin <- c(lst$user_group$admin, 'user1')

# save to access settings
save_access_yaml(lst)

}
