% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotPCA.ly}
\alias{plotPCA.ly}
\title{Plot an interactive PCA plot}
\usage{
plotPCA.ly(rld, intgroup)
}
\arguments{
\item{rld}{DESeqTransform object output by varianceStabilizingTransformation() or rlog()}

\item{intgroup}{character vector of names in colData(x) to use for grouping}
}
\value{
Handle to ggplot with added label field in aes_string() for plotting with ggplotly()
}
\description{
Plot an interactive PCA plot
}
\examples{
# make example dds object
dds <- DESeq2::makeExampleDESeqDataSet()

# normalize
rld <- DESeq2::varianceStabilizingTransformation(dds, blind=TRUE)

# make pca plot
p <- plotPCA.ly(rld, intgroup='condition')

}
