% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca-plot.R
\name{pcamod}
\alias{pcamod}
\alias{pcaPlotUI}
\alias{pcaPlotServer}
\title{PCA plot module}
\usage{
pcaPlotUI(id, panel)

pcaPlotServer(id, obj, coldata, config)
}
\arguments{
\item{id}{Module id}

\item{panel}{string, can be 'sidebar' or 'main'}

\item{obj}{reactiveValues object containing carnation object}

\item{coldata}{reactiveValues object containing object metadata}

\item{config}{reactive list with config settings}
}
\value{
UI returns tagList with PCA plot UI.
Server invisibly returns NULL (used for side effects).
}
\description{
Module UI + server to generate a pca plot.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)
library(DESeq2)

# Create reactive values to simulate app state
oobj <- make_example_carnation_object()

obj <- reactiveValues(
   dds = oobj$dds,
   rld = oobj$rld,
   res = oobj$res,
   all_dds = oobj$all_dds,
   all_rld = oobj$all_rld,
   dds_mapping = oobj$dds_mapping
)

# Set up coldata structure that the module expects
coldata <- reactiveValues(
  curr = list(
    all_samples = colData(oobj$dds$main),
    main = colData(oobj$dds$main)
  )
)

config <- reactiveVal(get_config())

shinyApp(
  ui = fluidPage(
         sidebarPanel(pcaPlotUI('p', 'sidebar')),
         mainPanel(pcaPlotUI('p', 'main'))
       ),
  server = function(input, output, session){
             pcaPlotServer('p', obj, coldata, config)
           }
)
\dontshow{\}) # examplesIf}
}
