% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma-plot.R
\name{maplotmod}
\alias{maplotmod}
\alias{maPlotUI}
\alias{maPlotServer}
\title{MA plot module}
\usage{
maPlotUI(id, panel)

maPlotServer(id, obj, plot_args, config)
}
\arguments{
\item{id}{Module id}

\item{panel}{string, can be 'sidebar' or 'main'}

\item{obj}{reactiveValues object containing carnation object}

\item{plot_args}{reactive containing 'fdr.thres' (padj threshold), 'fc.thres' (log2FC threshold)
& 'gene.to.plot' (genes selected in scratchpad)}

\item{config}{reactive list with config settings}
}
\value{
UI returns tagList with MA plot UI.
Server invisibly returns NULL (used for side effects).
}
\description{
UI & server for module to create MA plot
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)
library(DESeq2)

# Create reactive values to simulate app state
oobj <- make_example_carnation_object()

obj <- reactiveValues(
   dds = oobj$dds,
   rld = oobj$rld,
   res = oobj$res,
   all_dds = oobj$all_dds,
   all_rld = oobj$all_rld,
   dds_mapping = oobj$dds_mapping
)

# Set up coldata structure that the module expects
coldata <- reactiveValues(
  curr = list(
    all_samples = colData(oobj$dds$main),
    main = colData(oobj$dds$main)
  )
)

plot_args <- reactive({
  list(
    fdr.thres=0.1,
    fc.thres=0,
    gene.to.plot=c('gene1', 'gene2')
  )
})

config <- reactiveVal(get_config())

shinyApp(
  ui = fluidPage(
         sidebarPanel(maPlotUI('p', 'sidebar')),
         mainPanel(maPlotUI('p', 'main'))
       ),
  server = function(input, output, session){
             maPlotServer('p', obj, plot_args, config)
           }
)
\dontshow{\}) # examplesIf}
}
