% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{makeEnrichResult}
\alias{makeEnrichResult}
\title{Make an enrichResult obj from a data frame}
\usage{
makeEnrichResult(
  df,
  split = "/",
  keytype = "UNKNOWN",
  ontology = "UNKNOWN",
  type = "enrichResult"
)
}
\arguments{
\item{df}{data frame with functional enrichment results}

\item{split}{string, character used to split gene IDs}

\item{keytype}{type of gene ID}

\item{ontology}{ontology database being used}

\item{type}{string, can be 'enrichResult' or 'gseaResult'}
}
\value{
enrichResult object
}
\description{
Most of the parameters are just placeholders and the
dataframe must contain the columns 'ID' and 'geneID'
}
\examples{
# get enrichResult object
data(eres_dex, package='carnation')

# extract the results
df <- as.data.frame(eres_dex)

# convert to a stripped down enrichResult object
eres2 <- makeEnrichResult(df)

}
