% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_y_init}
\alias{get_y_init}
\title{Get initial y-axis limits}
\usage{
get_y_init(df, y_delta, pseudocount)
}
\arguments{
\item{df}{data.frame with counts. Must have column 'count'}

\item{y_delta}{y-axis padding for visualization, must be
between 0 and 1}

\item{pseudocount}{pseudo-count to add to the data.frame}
}
\value{
min and max limits for count column, padded for visualization
}
\description{
Get initial y-axis limits
}
\examples{
# make example DESeq dataset
dds <- DESeq2::makeExampleDESeqDataSet()

# get gene counts
df <- get_gene_counts(dds, gene = c('gene1', 'gene2'))

# get y axis limits
get_y_init(df, y_delta = 0.01, pseudocount = 1)

}
