% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_project_name_from_path}
\alias{get_project_name_from_path}
\title{Get project name from path}
\usage{
get_project_name_from_path(
  x,
  depth = 2,
  end_offset = 0,
  staging_dir = "dev",
  fsep = .Platform$file.sep
)
}
\arguments{
\item{x}{character path to RDS file}

\item{depth}{integer how many levels below path to look?}

\item{end_offset}{integer how far from the end of path to end?}

\item{staging_dir}{name of staging directory}

\item{fsep}{file separator to split path with}
}
\value{
project name parsed from path to object
}
\description{
This function takes in a path to an RDS file and returns
a string to be used as project name
}
\examples{
# path to carnation object
obj_path <- "/path/to/project/test/main.rnaseq.rds"

# parsed project name
get_project_name_from_path(obj_path, depth = 2, end_offset = 0)

}
