% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene-plot.R
\name{geneplotmod}
\alias{geneplotmod}
\alias{genePlotUI}
\alias{genePlotServer}
\title{Gene plot module}
\usage{
genePlotUI(id, panel)

genePlotServer(id, obj, coldata, plot_args, config)
}
\arguments{
\item{id}{Module id}

\item{panel}{string, can be 'sidebar' or 'main'}

\item{obj}{reactiveValues object containing carnation object}

\item{coldata}{reactiveValues object containing object metadata}

\item{plot_args}{reactive list with 3 elements: 'gene.id' (all gene IDs) & 'gene_scratchpad'
(genes selected in scratchpad) & 'comp_all' (selected comparison)}

\item{config}{reactive list with config settings}
}
\value{
UI returns tagList with gene plot UI.
Server invisibly returns NULL (used for side effects).
}
\description{
UI & server for module to create gene plot
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)
library(DESeq2)

# Create reactive values to simulate app state
oobj <- make_example_carnation_object()

obj <- reactiveValues(
   dds = oobj$dds,
   rld = oobj$rld,
   res = oobj$res,
   all_dds = oobj$all_dds,
   all_rld = oobj$all_rld,
   dds_mapping = oobj$dds_mapping
)

# Set up coldata structure that the module expects
coldata <- reactiveValues(
  curr = list(
    all_samples = colData(oobj$dds$main),
    main = colData(oobj$dds$main)
  )
)

plot_args <- reactive({
  list(
    gene.to.plot = c("gene1", "gene2"),
    gene.id = rownames(oobj$dds$main),
    comp_all = "comp1"
  )
})

config <- reactiveVal(get_config())

shinyApp(
  ui = fluidPage(
         sidebarPanel(genePlotUI('p', 'sidebar')),
         mainPanel(genePlotUI('p', 'main'))
       ),
  server = function(input, output, session){
             genePlotServer('p', obj, coldata, plot_args, config)
           }
)
\dontshow{\}) # examplesIf}
}
