% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{format_genes}
\alias{format_genes}
\title{format gene names to look pretty in table output}
\usage{
format_genes(g, sep = "\\\\/", genes.per.line = 6)
}
\arguments{
\item{g}{vector of gene names}

\item{sep}{gene name separator}

\item{genes.per.line}{number of genes to show in a line}
}
\value{
vector of gene names prettified for data.table output
}
\description{
This function works by grouping long lists of genes
into groups of a specified size. Each group is collapsed
using commas, while groups are separated by spaces
so that datatable formatting is tricked into separating
space-separated groups and not comma-separated groups
}
\examples{
# string with genes separated by '/'
g <- "gene1/gene2/gene3/gene4/gene5/gene6/gene7"

gg <- format_genes(g, genes.per.line=3)

}
